//Thanks to Andy Murdoch for the MMX detection code

#include <windows.h>

/* We have to explicity trash the eax, ebx, ecx & edx registers so
 * MSVC knows they are modified.
 */
#define CPUID(FUNC) \
	__asm mov eax, FUNC \
	__asm xor ebx, ebx  \
	__asm xor ecx, ecx  \
	__asm xor edx, edx  \
	__asm _emit 0x0F __asm _emit 0xA2

DWORD DetectMMX(VOID) {
	DWORD MMXFound;

	/* Assume we can't find MMX */
	MMXFound = 0;

	__asm{
		; First we check for the presense of the CPUID
		; instruction, this works on 386s and above
		pushfd					; save the EFLAGS
		pop eax
		mov ebx, eax			; copy them to EBX
		xor eax, 0x00200000		; modify bit 21
		push eax
		popfd					; and put them back
		pushfd
		pop eax					; then get them again
		cmp eax, ebx			; compare to see if they are modified
		je end_of_mmx_test		; if they aren't this CPU is a 386/old 486

		; Now make sure function 1 is supported
		CPUID(0)				; makes eax = maximum CPUID function value
		cmp eax, 1				; Can this CPU execute CPUID function 1?
		jl end_of_mmx_test

		; Now get the capability bits and test the mmx one
		CPUID(1)
		shr edx, 23				; And push the MMX bit down to bit 0
		and edx, 0x01			; Clear all other bits
		mov [MMXFound], edx		; Put the value in a local variable

		end_of_mmx_test:
	}

	return MMXFound;
}
